<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;

class UserController extends Controller
{
    function dashboard()
    {
        $headertext = 'داشبورد';
        $notifications = DB::table('notification')->orderBy('id', 'DESC')->get();
        return view('user.dashboard', compact('headertext', 'notifications'));
    }

    function factors()
    {
        $headertext = 'فیش های حقوقی ' . Auth::user()->name;
        $factors = DB::table('factors')->where('139db701fcb5abff6c356874bb57dac2a611c177', '=', Auth::user()->usercode)->orderBy('id', 'DESC')->get();
        return view('user.factors', compact('headertext', 'factors'));
    }

    function factor($id, Request $request)
    {
        $download = $request->download;
        $factor = DB::table('factors')->where('139db701fcb5abff6c356874bb57dac2a611c177', '=', Auth::user()->usercode)->where('id', '=', $id)->first();
        if (isset($factor)) {
            $filds = DB::table('filds')->get();
            $headertext = 'فیش حقوقی ' . $factor->{'6d0a6b23037a8e4b3f78b3a42c0404a2b47eaa4f'} . '  (' . $factor->Tarikh . ')';
            $karkard = DB::table('karkard')->where('Code', '=', $factor->{'139db701fcb5abff6c356874bb57dac2a611c177'})->where('Salandmah', '=', $factor->{'109f1caeaa9b1842b47bfdaf8255fddac6f1e0a3'})->first();
            $karkardfilds = DB::table('karkardfilds')->get();
            return view('user.factor', compact('karkard', 'karkardfilds', 'filds', 'factor', 'headertext', 'download'));
        } else {
            return back();
        }
    }
    function registercheck(Request $request)
    {
        $request->validate([
            'nationalcode' => 'required|numeric',
            'usercode' => 'required|numeric',
        ], [
            'nationalcode.required' => 'لطفا کدملی خود را وارد نمایید',
            'national.numeric' => 'فرمت کدملی باید به صورت عدد باشد',
            'usercode.required' => 'لطفا کدپرسنلی خود را وارد نمایید',
            'usercode.numeric' => 'فرمت کدپرسنلی باید به صورت عدد باشد',
        ]);

        $b = DB::table('users')->where('usercode', '=', $request->usercode)->first();

        if ($b) {
            return back()->withErrors(['message' => 'با این کدپرسنلی کاربری قبلا ثبت نام کرده است']);
        } else {
            $q = DB::table('factors')->where('28ac8da350b288db7aac87d0657553c0e1b0d5da', '=', md5(sha1(md5($request->nationalcode))))->where('139db701fcb5abff6c356874bb57dac2a611c177', '=', $request->usercode)->first();

            if ($q) {
                $usercode = $request->usercode;
                $nationalcode = $request->nationalcode;
                return view('panel.registercheck', compact('usercode', 'nationalcode'));
            } else {
                return back()->withErrors(['message' => 'کدملی و کدپرسنلی وارد شده نامعتبر است و هیچ فیش حقوقی برای این کاربر ثبت نشده است']);
            }
        }
    }
    function finalregister(Request $request)
    {
        $request->validate([
            'usercode' => 'required|numeric',
            'password' => 'required|confirmed|min:8',
            'phone' => 'required|regex:/09/|digits:11|numeric',
        ], [
            'password.required' => 'لطفا رمزعبور خود را وارد نمایید',
            'password.confirmed' => 'رمزعبور با تکرار آن مطابقت ندارد',
            'password.min' => 'رمزعبور حداقل باید شامل ۸ حرف باشد',
            'usercode.required' => 'لطفا کدپرسنلی خود را وارد نمایید',
            'usercode.numeric' => 'فرمت کدپرسنلی باید به صورت عدد باشد',
            'phone.required' => 'لطفا شماره تلفن خود را وارد نمایید',
            'phone.regex' => 'شماره تلفن شما باید با 09 شروع شود',
            'phone.digits' => 'تعداد رقم های شماره تلفن صحیح نیست',
            'phone.numeric' => 'لطفا فرمت شماره تلفن را رعایت نمایید',
        ]);

        $c = DB::table('users')->where('phone', '=', $request->phone)->first();
        if ($c) {
            return back()->withErrors(['message' => 'این شماره تلفن قبلا ثبت شده است']);
        } else {
            $b = DB::table('users')->where('usercode', '=', $request->usercode)->first();

            if (!isset($b)) {
                $u = DB::table('factors')->where('139db701fcb5abff6c356874bb57dac2a611c177', '=', $request->usercode)->value('6d0a6b23037a8e4b3f78b3a42c0404a2b47eaa4f');
                $muser = DB::table('users')->insertGetId([
                    'name' => $u,
                    'phone' => $request->phone,
                    'usercode' => $request->usercode,
                    'password' => Hash::make($request->password)
                ]);

                Auth::loginUsingId($muser);
                return redirect()->route('user.dashboard');
            } else {
                return back()->withErrors(['message' => 'ثبت نام با مشکل مواجه شد']);
            }
        }
    }

    function logincheck(Request $request)
    {
        $request->validate([
            'usercode' => 'required|numeric',
            'password' => 'required|min:8',
        ], [
            'password.required' => 'لطفا رمزعبور خود را وارد نمایید',
            'password.min' => 'رمزعبور حداقل باید شامل ۸ حرف باشد',
            'usercode.required' => 'لطفا کدپرسنلی خود را وارد نمایید',
            'usercode.numeric' => 'فرمت کدپرسنلی باید به صورت عدد باشد',
        ]);


        $user = DB::table('users')->where('usercode', '=', $request->usercode)->first();
        if ($user && Hash::check($request->password, $user->password)) {
            Auth::loginUsingId($user->id);
            return redirect()->route('user.dashboard');
        } else {
            return back()->withErrors(['message' => 'چنین کاربری یافت نشد']);
        }
    }
}
