<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class userrequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return false;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'name' => 'required|min:3',
            'phone' => 'required|unique:users|digits:11|numeric|regex:/(09)[0-9]{9}/',
            'usercode' => 'required|unique:users|numeric',
        ];
    }

    public function messages()
    {
        return  [
            'name.required' => 'لطفا نام را وارد نمایید',
            'name.min' => 'نام حداقل باید ۳ حرف باشد',
            'phone.required' => 'لطفا شماره تلفن را وارد نمایید',
            'phone.unique' => 'این شماره تلفن قبلا در سیستم ثبت شده است',
            'phone.regex' => 'شماره تلفن باید با 09 شروع شود',
            'phone.digits' => 'شماره تلفن باید ۱۱ رقم باشد',
            'phone.numeric' => 'شماره تلفن نامعتبر است',
            'usercode.required' => 'لطفا کدپرسنلی را وارد نمایید',
            'usercode.unique' => 'این کدپرسنلی قبلا در سیستم ثبت شده است',
            'usercode.numeric' => 'کدپرسنلی باید عدد باشد',

        ];
    }
}
