@extends('admin.layouts.sidebar')

@section('content')
    <div class="row">


        <div class="col-lg-12">
            <div class="card">
                <div class="card-body">

                    <form action="{{ route('admin.factorlists') }}" method="get">


                        <div id="accordion">
                            <div class="card mb-1 shadow-none">
                                <div style="background-color: rgb(58, 92, 231)" class="card-header" id="headingOne">
                                    <a href="#collapseOne" class="text-dark collapsed" data-toggle="collapse"
                                        aria-expanded="false" aria-controls="collapseOne">
                                        <h6 style="color: white" class="m-0">
                                            جست و جو
                                        </h6>
                                    </a>
                                </div>

                                <div id="collapseOne" class="collapse" aria-labelledby="headingOne" data-parent="#accordion"
                                    style="">
                                    <div class="card-body line-height-p">
                                        <div class="form-group row">
                                            <label class="col-md-2 col-form-label">بر اساس</label>
                                            <div class="col-md-10">
                                                <select name="type" class="form-control">
                                                    @foreach ($filds as $fild)
                                                        <option
                                                            @if (isset($type) && $type == $fild->id) @selected(true) @endif
                                                            value="{{ $fild->id }}">{{ $fild->Name }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>


                                        <div class="form-group row">
                                            <label for="example-text-input" class="col-md-2 col-form-label">متن</label>
                                            <div class="col-md-10">
                                                <input placeholder="جست و جو بر اساس فیلد انتخاب شده بالا" name="inp"
                                                    class="form-control" type="text" id="example-text-input">
                                            </div>
                                        </div>



                                        <button type="submit" class="col-12 btn btn-primary waves-effect waves-light">جست و
                                            جو</button>

                                    </div>
                                </div>
                            </div>


                        </div>

                    </form>
                    <br><br>

                    <div class="table-responsive">
                        <table class="table table-striped mb-0">

                            <thead>
                                <tr>
                                    <th><input class="" type="checkbox" id="selectallcheckboxs"></th>
                                    <th>شماره</th>
                                    <th>نام</th>
                                    <th>شماره پرسنلی</th>
                                    <th>کارکرد</th>
                                    <th>تاریخ</th>
                                    <th>تغییرات</th>
                                </tr>
                            </thead>
                            <tbody>
                                <button type="button" data-toggle="modal" data-target=".bs-example-modal-lg"
                                    id="groupdeletebtn" style="margin-bottom: 20px;display: none;"
                                    class="btn btn-outline-primary waves-effect waves-light">حذف موارد انتخاب
                                    شده</button>
                                <form action="{{ route('admin.deletegroupfactors') }}" method="post">

                                    <div class="modal
                                                fade bs-example-modal-lg"
                                        tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel"
                                        aria-hidden="true">
                                        <div class="modal-dialog modal-lg">
                                            <div class="modal-content">
                                                <div class="modal-header">

                                                    <button type="button" class="close" data-dismiss="modal"
                                                        aria-label="Close">
                                                        <span aria-hidden="true">×</span>
                                                    </button>
                                                </div>
                                                <div class="modal-body">
                                                    <p>آیا از حذف فیش های انتخاب شده اطمینان دارید؟</p>
                                                    <button type="submit" type="button"
                                                        class="btn btn-danger waves-effect waves-light">حذف
                                                        فیلدها</button>
                                                </div>
                                            </div>
                                            <!-- /.modal-content -->
                                        </div>
                                        <!-- /.modal-dialog -->
                                    </div>
                                    <!-- /.modal -->
                                    @csrf

                                    @foreach ($factors as $factor)
                                        {{-- {{ dd($users) }} --}}
                                        <tr>
                                            <th>

                                                <input class="defaultCheck" name="deletedata[]" type="checkbox"
                                                    value="{{ $factor->id }}" id="checkboxs">

                                            </th>
                                            <th scope="row">{{ $loop->index + 1 }}</th>
                                            <td>{{ $factor->{'6d0a6b23037a8e4b3f78b3a42c0404a2b47eaa4f'} }}
                                            </td>
                                            <td>
                                                {{ $factor->{'139db701fcb5abff6c356874bb57dac2a611c177'} }}
                                            </td>
                                            <td>
                                                @if (checkkarkard(
                                                        $factor->{'109f1caeaa9b1842b47bfdaf8255fddac6f1e0a3'},
                                                        $factor->{'139db701fcb5abff6c356874bb57dac2a611c177'}) == true)
                                                    <span style="color: green">ثبت شده است</span>
                                                @else
                                                    <span style="color: red">یافت نشد</span>
                                                @endif

                                            </td>

                                            <td>
                                                {{ $factor->Tarikh }}
                                            </td>
                                            <td>

                                                <a href="{{ route('admin.showfactor', ['id' => $factor->id]) }}">نمایش</a>
                                                /
                                                <a href="" data-toggle="modal"
                                                    data-target=".bs-example-modal-lg{{ $factor->id }}">حذف</a>

                                                <!--  Modal content for the above example -->
                                                <div class="modal
                                                fade bs-example-modal-lg{{ $factor->id }}"
                                                    tabindex="-1" role="dialog"
                                                    aria-labelledby="myLargeModalLabel{{ $factor->id }}"
                                                    aria-hidden="true">
                                                    <div class="modal-dialog modal-lg">
                                                        <div class="modal-content">
                                                            <div class="modal-header">
                                                                <h5 class="modal-title mt-0"
                                                                    id="myLargeModalLabel{{ $factor->id }}">شما درحال
                                                                    حذف فیش
                                                                    {{ $factor->{'6d0a6b23037a8e4b3f78b3a42c0404a2b47eaa4f'} }}
                                                                    هستید</h5>
                                                                <button type="button" class="close" data-dismiss="modal"
                                                                    aria-label="Close">
                                                                    <span aria-hidden="true">×</span>
                                                                </button>
                                                            </div>

                                                            <div class="modal-body">
                                                                <p>آیا از حذف فیش اطمینان دارید؟</p>
                                                                <a href="{{ route('admin.deletefactor', ['id' => $factor->id]) }}"
                                                                    type="button"
                                                                    class="btn btn-danger waves-effect waves-light">حذف
                                                                    فیش</a>
                                                            </div>

                                                        </div>
                                                        <!-- /.modal-content -->
                                                    </div>
                                                    <!-- /.modal-dialog -->
                                                </div>
                                                <!-- /.modal -->
                    </div>
                    </td>


                    </tr>
                    @endforeach

                    </form>

                    </tbody>
                    </table>

                </div>

            </div>
        </div>
    </div>
    </div>
    {{ $factors->appends(request()->input())->render('pagination::bootstrap-4') }}
@endsection


@section('script')
    <script>
        var ch = [];
        const checkboxes = document.querySelectorAll('#checkboxs');

        checkboxes.forEach(checkbox => {
            checkbox.addEventListener('change', function(event) {
                if (event.target.checked) {
                    // Checkbox is checked
                    ch.push(event.target.value);
                    // console.log(ch);
                    // Perform actions for checked checkbox
                } else {
                    // Checkbox is unchecked
                    ch = ch.filter(item => item !== event.target.value)
                    // console.log(ch);
                    // Perform actions for unchecked checkbox
                }
                if (ch.length > 0) {
                    document.getElementById('groupdeletebtn').style.display = 'block';
                    // console.log(ch);
                } else {
                    document.getElementById('groupdeletebtn').style.display = 'none';
                    // console.log(ch);
                }
            });
        });

        document.getElementById('selectallcheckboxs').addEventListener('change', function(event) {
            if (event.target.checked) {
                checkboxes.forEach((checkbox, index) => {
                    ch.push(checkboxes[index].value);
                    checkboxes[index].checked = true;
                    // console.log((index + 1));
                });
                // console.log('hi');
            } else {
                ch = [];
                checkboxes.forEach((checkbox, index) => {
                    checkboxes[index].checked = false;
                })
            }
            if (ch.length > 0) {
                document.getElementById('groupdeletebtn').style.display = 'block';
                // console.log(ch.length);
            } else {
                document.getElementById('groupdeletebtn').style.display = 'none';
                // console.log(ch.length);
            }
        })
    </script>
@endsection
