@extends('panel.layouts.assets')

@section('content')
    <div class="account-pages my-5 pt-sm-5">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-md-8 col-lg-6 col-xl-5">
                    <div class="card overflow-hidden">
                        <div class="bg-login text-center">
                            <div class="bg-login-overlay"></div>
                            <div class="position-relative">
                                <h5 class="text-white font-size-20">ورود</h5>
                                <p class="text-white-50 mb-0">ورود به پنل کاربری سامانه فیش حقوقی</p>
                                <a href="{{ route('index') }}" class="logo logo-admin mt-4">
                                    <img src="{{ asset('logo.png') }}" alt="" height="30">
                                </a>
                            </div>
                        </div>
                        <div class="card-body pt-5">
                            <div class="p-2">
                                <form class="form-horizontal" method="POST" action="{{ route('logincheck') }}">
                                    @csrf

                                    <div class="form-group">
                                        <label for="usercode">کدپرسنلی</label>
                                        <input style="text-align: center" name="usercode" value="{{ old('usercode') }}"
                                            type="text" class="form-control" id="usercode"
                                            placeholder="کدپرسنلی را وارد کنید">
                                    </div>

                                    <div class="form-group">
                                        <label for="userpassword">رمز عبور</label>
                                        <input style="text-align: center" name="password" type="password"
                                            class="form-control" id="userpassword" placeholder="رمز عبور را وارد کنید">
                                    </div>


                                    <div class="mt-3">
                                        <button class="btn btn-primary btn-block waves-effect waves-light"
                                            type="submit">ورود</button>
                                    </div>


                                </form>
                                <br>

                                <div style="text-align: center" class="col-12">
                                    <a href="{{ route('loginwithphone') }}">ورود با شماره تلفن</a>
                                </div>
                                <br>
                                <div style="text-align: center" class="col-12">
                                    <a href="{{ route('register') }}">رفتن به صفحه ثبت نام</a>
                                </div>

                                <br><br>

                                @if ($errors->any())
                                    @foreach ($errors->all() as $error)
                                        <div class="alert alert-danger" role="alert">
                                            {{ $error }}
                                        </div>
                                    @endforeach
                                @endif

                                @if (session()->has('message'))
                                    <div class="t-center alert alert-danger" role="alert">
                                        {{ session()->get('message') }}
                                    </div>
                                @endif
                            </div>

                        </div>
                    </div>


                </div>
            </div>
        </div>
</div @endsection
