<?php

use App\Http\Controllers\Admin\Auth\AuthController;
use App\Http\Controllers\ProfileController;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', function () {
    return view('index');
})->name('index');

Route::get('/faq', function () {
    return view('faq');
})->name('faq');
Route::get('/contactus', function () {
    return view('contactus');
})->name('contactus');
Route::get('/aboutus', function () {
    return view('aboutus');
})->name('aboutus');
Route::get('/loginwithphone', function () {
    return view('panel.loginwithphone');
})->name('loginwithphone');



Route::post('/logincheck', '\App\Http\Controllers\UserController@logincheck')->name('logincheck');
Route::get('/registercheck', '\App\Http\Controllers\UserController@registercheck')->name('registercheck');
Route::post('/finalregister', '\App\Http\Controllers\UserController@finalregister')->name('finalregister');




Route::post('/clogout', "\App\Http\Controllers\Auth\AuthenticatedSessionController@destroy")->name('clogout');

Route::get('/admin/login', function () {
    if (Auth::guard('admin')->check()) {
        return redirect()->route('admin.dashboard');
    } else {
        return view('admin.login');
    }
})->name('adminlogin');

Route::post('admin/login', "\App\Http\Controllers\Admin\Auth\AdminController@logincheck")->name('admin.logincheck');


Route::middleware('auth')->name('user.')->controller('\App\Http\Controllers\UserController')->group(function () {
    Route::get('user/dashboard', "dashboard")->name('dashboard');
    Route::get('user/factors', "factors")->name('factors');
    Route::get('user/factor/{id}', "factor")->name('factor');
});




Route::middleware('admin')->name('admin.')->group(function () {

    // users
    Route::controller('\App\Http\Controllers\Admin\Auth\AdminController')->group(function () {
        Route::get('admin/dashboard', "dashboard")->name('dashboard');
        Route::get('admin/adduserbyexcel', "adduserbyexcel")->name('adduserbyexcel');
        Route::post('admin/adduserbyexcel', "adduserbyexcelcheck")->name('adduserbyexcelcheck');
        Route::get('admin/adduser', "adduser")->name('adduser');
        Route::post('admin/adduser', "addusercheck")->name('addusercheck');
        Route::get('admin/userslists', "userslists")->name('userslists');
        Route::get('admin/deleteuser/{id}', "deleteuser")->name('deleteuser');
        Route::get('admin/edituser/{id}', "edituser")->name('edituser');
        Route::post('admin/deletegroupusers', "deletegroupusers")->name('deletegroupusers');
        Route::get('admin/notiflist', "notiflist")->name('notiflist');
        Route::get('admin/addnotif', "addnotif")->name('addnotif');
        Route::post('admin/addnotif', "addnotifcheck")->name('addnotifcheck');
        Route::get('admin/deletenotif/{id}', "deletenotif")->name('deletenotif');
        Route::post('admin/notifdeletegroup', "notifdeletegroup")->name('notifdeletegroup');
    });


    // factors filds
    Route::controller('\App\Http\Controllers\Admin\FactorFildsController')->group(function () {
        Route::get('admin/factorfildslists', "fildslists")->name('factorfildslists');
        Route::get('admin/factoraddfild', "addfild")->name('factoraddfild');
        Route::post('admin/factoraddfild', "addfildcheck")->name('factoraddfildcheck');
        Route::get('admin/factordeletefild/{id}', "deletefild")->name('factordeletefild');
        Route::post('admin/factordeletegroupfilds', "deletegroupfilds")->name('factordeletegroupfilds');
        Route::get('admin/factorfildslists', "fildslists")->name('factorfildslists');
    });


    // karkard filds
    Route::controller('\App\Http\Controllers\Admin\KarkardFildsController')->group(function () {
        Route::get('admin/karkardfildslists', "fildslists")->name('karkardfildslists');
        Route::get('admin/karkardaddfild', "addfild")->name('karkardaddfild');
        Route::post('admin/karkardaddfild', "addfildcheck")->name('karkardaddfildcheck');
        Route::get('admin/karkarddeletefild/{id}', "deletefild")->name('karkarddeletefild');
        Route::post('admin/karkarddeletegroupfilds', "deletegroupfilds")->name('karkarddeletegroupfilds');
        Route::get('admin/karkardfildslists', "fildslists")->name('karkardfildslists');
    });


    // factor
    Route::controller('\App\Http\Controllers\Admin\FactorController')->group(function () {
        Route::get('admin/addfactor', "addfactor")->name('addfactor');
        Route::get('admin/addkarkard', "addkarkard")->name('addkarkard');
        Route::post('admin/addfactorcheck', "addfactorcheck")->name('addfactorcheck');
        Route::post('admin/addkarkardcheck', "addkarkardcheck")->name('addkarkardcheck');
        Route::get('admin/factorlists', "factorlists")->name('factorlists');
        Route::get('admin/factorlists/{userid}', "factorlistsbyuser")->name('factorlistsbyuser');
        Route::post('admin/deletegroupfactors', "deletegroupfactors")->name('deletegroupfactors');
        Route::get('admin/deletefactor/{id}', "deletefactor")->name('deletefactor');
        Route::get('admin/showfactor/{id}', "showfactor")->name('showfactor');
        Route::get('admin/downloadfactorfild', "downloadfactorfild")->name('downloadfactorfild');
        Route::get('admin/downloadkarkardfild', "downloadkarkardfild")->name('downloadkarkardfild');
    });
});

Route::get('/dashboard', function () {
    return view('dashboard');
})->middleware(['auth', 'verified'])->name('dashboard');

Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});

require __DIR__ . '/auth.php';
